package com.qboxus.tictic.activitesfragments.shoping;


import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import androidx.activity.result.ActivityResult;
import androidx.activity.result.ActivityResultCallback;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.contract.ActivityResultContracts;
import androidx.databinding.DataBindingUtil;
import androidx.fragment.app.Fragment;
import androidx.recyclerview.widget.LinearLayoutManager;

import com.google.gson.Gson;
import com.qboxus.tictic.activitesfragments.chat.ChatActivity;
import com.qboxus.tictic.simpleclasses.Dialogs;
import com.volley.plus.VPackages.VolleyRequest;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;

import com.qboxus.tictic.Constants;
import com.qboxus.tictic.R;
import com.qboxus.tictic.activitesfragments.shoping.adapter.OrderDetailAdapter;
import com.qboxus.tictic.activitesfragments.shoping.models.OrderHistoryModel;
import com.qboxus.tictic.activitesfragments.shoping.models.OrderProduct;
import com.qboxus.tictic.apiclasses.ApiLinks;
import com.qboxus.tictic.databinding.FragmentOrderHistoryDetailBinding;
import com.qboxus.tictic.interfaces.AdapterClickListener;
import com.qboxus.tictic.simpleclasses.Functions;
import com.qboxus.tictic.simpleclasses.Variables;

public class OrderHistory_F extends Fragment implements View.OnClickListener {

    boolean isview = false;
    boolean isTrue;


    OrderHistoryModel model;
    FragmentOrderHistoryDetailBinding binding;

    public OrderHistory_F() {
        // Required empty public constructor
    }


    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        // Inflate the layout for this fragment
        binding= DataBindingUtil.inflate(inflater, R.layout.fragment_order_history_detail, container, false);

        Bundle bundle = getArguments();
        model=(OrderHistoryModel) bundle.getParcelable("data");

        methodInitializeClickListner();


        binding.orderIdTxt.setText(model.order.id);

        if (isTrue) {
            binding.trackOrderBtn.setVisibility(View.VISIBLE);
        } else {
            binding.trackOrderBtn.setVisibility(View.GONE);
        }

        fetchOrderHistoryDetailApi();

        return binding.getRoot();
    }

    private void methodInitializeClickListner() {
        binding.backIcon.setOnClickListener(this);
        binding.contactStoreBtn.setOnClickListener(this);
        binding.trackOrderBtn.setOnClickListener(this);
        binding.delievryInfoDiv.setOnClickListener(this);

    }

    public void setData(){

        binding.totalDiscountTv.setText(Constants.productShowingCurrency +model.order.discount);
        binding.totalPriceTv.setText(Constants.productShowingCurrency + model.order.total);
        binding.orderDateTxt.setText(model.order.created);

        binding.totalShippingTv.setText(Constants.productShowingCurrency + model.order.delivery_fee);
        binding.totalSubTv.setText(Constants.productShowingCurrency + model.order.total);

        binding.totalPriceTv.setText(Constants.productShowingCurrency + model.order.total);

        if (model.order.status.equals("0")) {
            binding.orderStatusTxt.setText("Pending");
        } else if (model.order.status.equals("1")) {
            binding.orderStatusTxt.setText("Active");
        } else if (model.order.status.equals("2")) {
            binding.orderStatusTxt.setText("Completed");
            binding.trackOrderBtn.setVisibility(View.GONE);
        } else if (model.order.status.equals("3")) {
            binding.orderStatusTxt.setText("Cancel");
            binding.trackOrderBtn.setVisibility(View.GONE);
        }

        binding.orderUserEmailTv.setText(model.user.email);
        binding.orderUserNameTv.setText(model.user.username);

        binding.orderStoreName.setText(model.store.username);

        binding.orderUserAddressTv.setText(model.deliveryAddress.getLocation_string());
        binding.orderUserCityTv.setText(model.deliveryAddress.city);
        binding.orderUserPostalTv.setText(model.deliveryAddress.zip);


        writeRecycler(model.orderProduct);

    }

    @Override
    public void onClick(View v) {

        switch (v.getId()) {
            case R.id.delievry_info_div:
                if (isview) {
                    binding.infoRlt.setVisibility(View.VISIBLE);
                    binding.arrowDown.setVisibility(View.GONE);
                    binding.arrowUp.setVisibility(View.VISIBLE);
                    isview = false;
                } else {
                    binding.infoRlt.setVisibility(View.GONE);
                    binding.arrowDown.setVisibility(View.VISIBLE);
                    binding.arrowUp.setVisibility(View.GONE);
                    isview = true;
                }
                break;

            case R.id.track_order_btn:
//                Intent intent1 = new Intent(getActivity(), TrackOrderA.class);
//                intent1.putExtra("order_id", model.order.id);
//                startActivity(intent1);
                break;

            case R.id.contact_store_btn:
                Intent intent=new Intent(getActivity(), ChatActivity.class);
                intent.putExtra("user_id", model.order.store_user_id);
                startActivity(intent);
                getActivity().overridePendingTransition(R.anim.in_from_right, R.anim.out_to_left);
                break;
            case R.id.back_icon:
                getActivity().onBackPressed();
                break;

            default:
                break;


        }

    }


    private void fetchOrderHistoryDetailApi() {

         Functions.showLoader(getActivity(), false, false);
        JSONObject params = new JSONObject();
        try {
            params.put("user_id", Functions.getSharedPreference(getContext()).getString(Variables.U_ID,""));
            params.put("order_id", model.order.id);
        } catch (JSONException e) {
            e.printStackTrace();
        }

        VolleyRequest.JsonPostRequest(getActivity(), ApiLinks.showOrderDetail, params,Functions.getHeaders(requireContext()), new com.volley.plus.interfaces.Callback() {
            @Override
            public void onResponce(String resp) {
                Functions.cancelLoader();
                if (resp != null) {
                    try {
                        JSONObject response = new JSONObject(resp);
                        int code = response.optInt("code");
                        if (code == 200) {
                            JSONObject msgObj = response.optJSONObject("msg");
                            model = new Gson().fromJson(String.valueOf(msgObj), OrderHistoryModel.class);
                            setData();

                        }
                    } catch (JSONException e) {
                        e.printStackTrace();
                    }
                }

            }
        });

    }

    private void writeRecycler(ArrayList<OrderProduct> datalist) {
        binding.recylerview.setLayoutManager(new LinearLayoutManager(getContext()));
        binding.recylerview.setHasFixedSize(true);
        OrderDetailAdapter adapter = new OrderDetailAdapter(getContext(), model, datalist, new AdapterClickListener() {
            @Override
            public void onItemClick(View view, int pos, Object object) {
                if(view.getId()==R.id.ratingLayout){
                    OrderProduct orderProduct=(OrderProduct) object;
                    if(orderProduct.productRating==null) {
                        openRatingScreen(orderProduct);
                    }
                }
            }
        });
        binding.recylerview.setAdapter(adapter);

        binding.recylerview.setNestedScrollingEnabled(false);
    }


    public void openRatingScreen(OrderProduct orderProduct){

        Intent intent=new Intent(getActivity(), RatingA.class);
        intent.putExtra("data", orderProduct);
        intent.putExtra("order_id", model.order.id);
        resultCallback.launch(intent);
        getActivity().overridePendingTransition(R.anim.in_from_right, R.anim.out_to_left);

    }

    ActivityResultLauncher<Intent> resultCallback = registerForActivityResult(
            new ActivityResultContracts.StartActivityForResult(), new ActivityResultCallback<ActivityResult>() {
                @Override
                public void onActivityResult(ActivityResult result) {
                    if (result.getResultCode() == Activity.RESULT_OK) {
                        fetchOrderHistoryDetailApi();
                    }
                }
            });


}
